
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jan 13 09:23:24 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_RSA_Verify.c#1:csrc:6
   *  \author ohads
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/

#include "DX_VOS_Mem.h" 
#include "CRYS_RSA_error.h"
#include "CRYS.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"


/************************ Defines ******************************/

/* canceling the lint warning:
   Use of goto is deprecated */
/*lint --e{801} */

/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/


/************* Private function prototype ****************/


#ifndef	_INTERNAL_CRYS_NO_RSA_VERIFY_SUPPORT
/************************ Private Functions ******************************/

/**

   \brief RSA_VerifyInit implements the Verify algorithm either for 
   OKCS1 Ver 1.5 or Ver 2.1
   
   @param[in,out] UserContext_ptr - Pointer to a Context. The value
                                returned here must be passed to
                                the Update and Finish functions.
   @param[in] UserPubKey_ptr - Pointer to the User public key data
	                           structure as built in the Build function.
   @param[in] hashFunc - The hash function to be used. Currently
                         only CRYS_PKCS1_SHA1 is supported. The
                         other hash functions recommended by PKCS#1
                         v2.1 are SHA-256/284/512.
   @param[in] MGF - the mask generation function. PKCS#1 v2.1
                    defines MGF1, so the only value allowed here
                    is CRYS_PKCS1_MGF1. 
   @param[in] SaltLen - The Length of the Salt buffer. relevant for PKCS#1 Ver 2.1 Only
   						Typical lengths are 0 and hLen (20 for SHA1)
   						The maximum length allowed is NSize - hLen - 2
                        If the salt length is not available in this process, the user can use the define:
                        CRYS_RSA_VERIFY_SALT_LENGTH_UNKNOWN
                        Security Note: it is recommended not to use this flag and to support the Salt length on each verify
   @param[in] PKCS1_ver - Ver 1.5 or 2.1 according to the functionality required
   
   @return CRYSError_t - CRYS_OK, CRYS_BAD_PARAM
*/


CEXPORT_C CRYSError_t _DX_RSA_VerifyInit(CRYS_RSAPubUserContext_t *UserContext_ptr,
                               CRYS_RSAUserPubKey_t *UserPubKey_ptr,
                               CRYS_RSA_HASH_OpMode_t hashFunc,
                               CRYS_PKCS1_MGF_t MGF,
                               DxUint16_t SaltLen,			      
                               CRYS_PKCS1_version PKCS1_ver)
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_INIT_OP_CODE, 6,
	   							 /* PARAMETERS: */
								 UserContext_ptr,
								 UserPubKey_ptr,
								 hashFunc,
								 MGF,
								 SaltLen,			      
							 	 PKCS1_ver );
	
}/* END OF _DX_RSA_VerifyInit */  				  


/**********************************************************************************************************/
/**
 
 
   \brief RSA_VerifyUpdate the update phase for the Verify algorithm either for 
   PKCS1 Ver 1.5 or Ver 2.1 

   @param[in] UserContext_ptr - Pointer to a valid context as
                            returned by CRYS_RSA_VerifyInit.
   @param[in] Data_ptr - Pointer to the data whose signature is
                         to be verified.
   @param[in] DataSize - The size, in bytes, of the data whose
                         signature is to be verified.

   @return CRYSError_t - CRYS_OK, CRYS_BAD_PARAM
*/   

CEXPORT_C CRYSError_t _DX_RSA_VerifyUpdate(CRYS_RSAPubUserContext_t *UserContext_ptr,
                                 DxUint8_t     *DataIn_ptr,
                                 DxUint32_t     DataInSize)
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_UPDATE_OP_CODE, 3,
	   							 /* PARAMETERS: */
								 UserContext_ptr,
								 DataIn_ptr, DataInSize );
	
}/* END OF _DX_RSA_VerifyUpdate */			      		
			      

/**********************************************************************************************************/
/**

   \brief RSA_VerifyFinish implements the Finish Phase of the Verify algorithm
   as defined in PKCS#1 v2.1 or PKCS#1 v1.5

   @param[in] UserContext_ptr - Pointer to a valid context as
                            returned by CRYS_RSA_PSS_VerifyInit.
                            

   @param[in] Sig_ptr - Pointer to the signature to be
                        verified. The length of the signature is
                        PubKey_ptr->N.len bytes (that is, the
                        size of the modulus, in bytes).

   @return CRYSError_t - CRYS_OK, CRYS_INVALID_SIGNATURE,
                         CRYS_BAD_PARAM, CRYS_OUT_OF_RANGE 
*/



CEXPORT_C CRYSError_t _DX_RSA_VerifyFinish(CRYS_RSAPubUserContext_t *UserContext_ptr,
                                 DxUint8_t *Sig_ptr)			      
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_FINISH_OP_CODE, 2,
	   							 /* PARAMETERS: */
								 UserContext_ptr,
								 Sig_ptr );
	
}/* END OF _DX_RSA_VerifyFinish */			      


/**********************************************************************************************************/
/**
   \brief CRYS_RSA_PKCS1v15_Verify implements the RSASSA-PKCS1v15 algorithm
   as defined in PKCS#1 v2.1 9.2

	The actual macro that will be used by the users is:
	CRYS_RSA_PKCS1v15_Verify
	
   @param[in] UserContext_ptr - Pointer to the public Context, for the use of the 
   								function as a space to work on			
   @param[in] UserPubKey_ptr - Pointer to the public key data
                           structure of the user.
   @param[in] hashFunc - The hash function to be used. Currently
                         only CRYS_PKCS1_SHA1 and CRYS_PKCS1_MD5
                         are supported. The other hash functions
                         recommended by PKCS#1 v2.1 are
                         SHA-256/284/512. 
   @param[in] MGF - the mask generation function. only for PKCS#1 v2.1
                    defines MGF1, so the only value allowed for v2.1 
                    is CRYS_PKCS1_MGF1.
   @param[in] SaltLen - The Length of the Salt buffer. relevant for PKCS#1 Ver 2.1 Only
   						Typical lengths are 0 and hLen (20 for SHA1)
   						The maximum length allowed is NSize - hLen - 2                                              
   @param[in] DataIn_ptr - Pointer to the data whose signature is
                         to be verified.
   @param[in] DataInSize - The size, in bytes, of the data whose
                         signature is to be verified.
   @param[in] Sig_ptr - Pointer to the signature to be
                        verified. The length of the signature is
                        PubKey_ptr->N.len bytes (that is, the
                        size of the modulus, in bytes).
   @param[in] PKCS1_ver - Ver 1.5 or 2.1 according to the functionality required

   @return CRYSError_t - CRYS_OK, CRYS_INVALID_SIGNATURE,
                         CRYS_BAD_PARAM, CRYS_OUT_OF_RANGE 
*/

				     
CEXPORT_C CRYSError_t _DX_RSA_Verify(CRYS_RSAPubUserContext_t *UserContext_ptr,
                           CRYS_RSAUserPubKey_t *UserPubKey_ptr,
                           CRYS_RSA_HASH_OpMode_t hashFunc,
                           CRYS_PKCS1_MGF_t MGF,
                           DxUint16_t SaltLen,
                           DxUint8_t     *DataIn_ptr,
                           DxUint32_t     DataInSize,
                           DxUint8_t     *Sig_ptr,
                           CRYS_PKCS1_version PKCS1_ver)
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_OP_CODE, 9,
	   							 /* PARAMETERS: */
								 UserContext_ptr,
								 UserPubKey_ptr,
								 hashFunc,
								 MGF,
							 	 SaltLen,
								 DataIn_ptr,
								 DataInSize,
								 Sig_ptr,
								 PKCS1_ver );

}/* END OF _DX_RSA_Verify */

#endif /*_INTERNAL_CRYS_NO_RSA_VERIFY_SUPPORT*/
